﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace PackageCreator
{
    public class PackageCreatorParam
    {
        private string RootPath;
        [CommandLineOption(
            "root",
            IsRequired = true,
            ValueName = "path",
            Description = "SDK のルートパスを指定します。")]
        public string SdkRoot
        {
            get
            {
                return RootPath;
            }
            private set
            {
                // 必ず区切り文字で終わるように
                RootPath = Path.GetFullPath(
                                    value.EndsWith(Path.DirectorySeparatorChar.ToString()) ?
                                    value : value + Path.DirectorySeparatorChar);
            }
        }

        [CommandLineOption(
            "source-file",
            IsRequired = true,
            ValueName = "path",
            DefaultValue = null,
            Description = "作成したいパッケージの定義ファイルを指定します。\n")]
        public string SourceFilePath { get; private set; }

        private string OutputDirPath;
        [CommandLineOption(
            "output-dir",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "パッケージの出力先を指定します。\n"
                + "指定しなかった場合、--root で指定したディレクトリに出力します。\n")]
        public string OutputPath
        {
            get
            {
                return string.IsNullOrWhiteSpace(OutputDirPath) ? SdkRoot : OutputDirPath;
            }
            private set
            {
                if (string.IsNullOrWhiteSpace(value))
                {
                    OutputDirPath = SdkRoot;
                }
                else
                {
                    // 必ず区切り文字で終わるように
                    OutputDirPath = Path.GetFullPath(
                                        value.EndsWith(Path.DirectorySeparatorChar.ToString()) ?
                                        value : value + Path.DirectorySeparatorChar);
                }
            }
        }

        [CommandLineOption(
            "output-name",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "パッケージのファイル名を指定します。\n")]
        public string OutputFilename { get; private set; }

        [CommandLineOption(
            "translate",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "フォルダ構成変換ルールファイルを指定します。\n"
                + "指定しなかった場合、フォルダ構成は変換できません。\n")]
        public string TranslateFilePath { get; private set; }

        [CommandLineOption(
            "forbidden",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "禁止ワードファイルを指定します。\n"
                + "指定しなかった場合、禁止ワードのチェックを行いません。\n")]
        public string ForbiddenFilePath { get; private set; }

        [CommandLineOption(
            "no-create-archives",
            DefaultValue = false,
            IsRequired = false,
            Description = "パッケージのzipファイルを作成しないようにします。\n"
                + "指定しなかった場合、パッケージのzipファイルを生成します。\n")]
        public bool NoCreateArchives { get; private set; }

        public bool ShouldArchive
        {
            get
            {
                return !NoCreateArchives;
            }
        }

        [CommandLineOption(
            "file-list",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "入力ファイルのリストを出力するパスを指定します。\n"
                + "指定した場合、パッケージングの実処理は行われません。\n")]
        public string FileListPath { get; private set; }

        [CommandLineOption(
            "extra-source-file-list",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "ワイルドカードの処理対象で、追加するファイルのリストを指定します。\n")]
        public string ExtraSourceFileListPath { get; private set; }

        [CommandLineOption(
            "select-file-tree",
            IsRequired = false,
            ValueName = "fs|list",
            DefaultValue = "fs",
            Description = "ファイルツリーの指定方法を指定します。\n")]
        public string FileTreeSelectionString { get; private set; }

        public FileTreeSelectionKind? FileTreeSelection
        {
            get
            {
                switch (FileTreeSelectionString)
                {
                    case "fs": return FileTreeSelectionKind.FileSystem;
                    case "list": return FileTreeSelectionKind.ListFile;
                    default: return null;
                }
            }
        }

        [CommandLineOption(
            "source-file-list",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "ファイルツリーの指定方法として 'list' を選択した際に使用するリストファイルを指定します。\n")]
        public string SourceFileListPath { get; private set; }

        [CommandLineOption(
            "check-file-existence",
            IsRequired = false,
            ValueName = "ignore|warning|error",
            DefaultValue = "error",
            Description = "存在しないファイルに対する処理を指定します。\n")]
        public string FileExistenceCheckLevelString { get; private set; }

        public FileExistenceCheckLevelKind? FileExistenceCheckLevel
        {
            get
            {
                switch (FileExistenceCheckLevelString)
                {
                    case "ignore": return FileExistenceCheckLevelKind.Ignore;
                    case "warning": return FileExistenceCheckLevelKind.Warning;
                    case "error": return FileExistenceCheckLevelKind.Error;
                    default: return null;
                }
            }
        }

        [CommandLineOption(
            "revision-file",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "リビジョン情報を含むテキストファイルのパスを指定します。\n")]
        public string RevisionFilePath { get; private set; }

        [CommandLineOption(
            "output-revision-file",
            IsRequired = false,
            ValueName = "path",
            DefaultValue = null,
            Description = "リビジョン情報を含むテキストファイルの出力先パスを指定します。\n")]
        public string OutputRevisionFilePath { get; private set; }
    }
}
