﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

using System.IO;
using System.IO.Ports;

namespace NxAgingHelper
{
    /// <summary>
    /// エスケープシーケンスの削除やタイムスタンプの追加を行うフォーマッタ
    /// </summary>
    public class UartLoggerFormatter
    {
        private bool m_StartWithTimeStamp = true;
        private bool m_InEscapeSequence = false;

        public string Format(string text)
        {
            if (text == null || text.Equals(string.Empty))
            {
                return text;
            }

            DateTime now = DateTime.Now;
            string timeStamp = now.ToString("[yyyy-MM-dd HH:mm:ss.fff] ");

            var builder = new StringBuilder();

            if (m_StartWithTimeStamp)
            {
                builder.Append(timeStamp);
                m_StartWithTimeStamp = false;
            }

            bool endsWithLineFeed = text.EndsWith("\n");
            if (endsWithLineFeed)
            {
                text = text.Remove(text.Length - 1);
            }

            foreach (var c in text)
            {
                if (c == '\x1b')
                {
                    m_InEscapeSequence = true;
                    continue;
                }
                if (m_InEscapeSequence && c == 'm')
                {
                    m_InEscapeSequence = false;
                    continue;
                }

                if (!m_InEscapeSequence)
                {
                    builder.Append(c);
                    if (c == '\n')
                    {
                        builder.Append(timeStamp);
                    }
                }
            }

            if (endsWithLineFeed)
            {
                builder.Append('\n');
                m_StartWithTimeStamp = true;
            }

            return builder.ToString();
        }
    }
}
