﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.Shell.Interop;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Global
{
    /// <summary>
    /// 利用者向けのログを出力する。
    /// </summary>
    public static class Logger
    {
        private static IServiceProvider _ServiceProvider;

        private static IVsOutputWindowPane _WindowPane;
        private static IVsOutputWindowPane WindowPane =>
            _WindowPane ?? (_WindowPane = GetWindowPane());

        public static void Initialize(IServiceProvider serviceProvider)
        {
            _ServiceProvider = serviceProvider;
        }

        public static void Dispose()
        {
        }

        public static void WriteGeneralLog(string format, params object[] args)
        {
            var s = string.Format(format, args);
            Debug.Write(s);
            WindowPane?.OutputStringThreadSafe(s);
        }

        private static IVsOutputWindowPane GetWindowPane()
        {
            var windowPane = (IVsOutputWindowPane)_ServiceProvider.GetService(typeof(SVsGeneralOutputWindowPane));
            if (windowPane == null)
            {
                Debug.WriteLine("WindowPane cannot be obtained.");
            }
            return windowPane;
        }
    }
}
