﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace Nintendo.NintendoSdkVsExtension.ViewModels
{
    internal class SdkRootStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var sdkRoot = (SdkRoot)value;
            switch (sdkRoot.Kind)
            {
                case SdkRootKind.DirectProperty:
                    return sdkRoot.Value;
                case SdkRootKind.NdiEnvironmentName:
                    return string.Format("NDI:{0}", sdkRoot.Value);
                default:
                    return null;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var s = value as string;
            if (s.StartsWith("NDI:"))
            {
                return new SdkRoot(SdkRootKind.NdiEnvironmentName, s.Substring(4));
            }
            else
            {
                return new SdkRoot(SdkRootKind.DirectProperty, s);
            }
        }
    }

    internal class BoolVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return (bool)value ? System.Windows.Visibility.Visible : System.Windows.Visibility.Hidden;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    internal class EnumStringConverter<T> : IValueConverter
        where T : struct
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return ((T)value).ToString();
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return Util.ParseEnumOrNull<T>((string)value) ?? Binding.DoNothing;
        }
    }

    internal class EnumRadioButtonCheckedConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return value.Equals(parameter);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return (bool)value ? parameter : Binding.DoNothing;
        }
    }

    // xaml でインスタンス化するための特殊化したクラス
    internal class SdkBuildTypeStringConverter : EnumStringConverter<SdkBuildType> { }
}
