﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Base
{
    public static class Util
    {
        public static TEnum ParseEnumOrDefault<TEnum>(string s, TEnum defaultValue)
            where TEnum : struct
        {
            TEnum value;
            if (Enum.TryParse(s, out value))
            {
                return value;
            }
            else
            {
                return defaultValue;
            }
        }

        public static TEnum? ParseEnumOrNull<TEnum>(string s)
            where TEnum : struct
        {
            TEnum value;
            if (Enum.TryParse(s, out value))
            {
                return value;
            }
            else
            {
                return null;
            }
        }

        public static SdkInformation LoadSdkInformationOrDefault(string rootPath)
        {
            try
            {
                return GlobalCaches.SdkInfomationCache.GetValue(rootPath);
            }
            catch (InvalidSdkRootException)
            {
                return null;
            }
        }
    }
}
