﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nlib/Config.h>
#include "./../../../../Programs/Eris/Sources/Libraries/ngc/succinct/ngc_InputStream.h"

namespace nn { namespace ngc { namespace detail {

struct FileInputStreamSettings
{
    void* buf;
    size_t bufferSize;

public:
    constexpr FileInputStreamSettings() NN_NOEXCEPT : buf(NULL), bufferSize(4096) {}
    constexpr FileInputStreamSettings(void* p, size_t size) NN_NOEXCEPT
        : buf(p),
          bufferSize(size) {}
};

class FileInputStream final : public InputStream
{
public:
    FileInputStream() NN_NOEXCEPT : m_Fd(NLIB_FD_INVALID),
                                    m_Buf(NULL),
                                    m_BufSize(0),
                                    m_IsInternalBuf(false) {}
    virtual ~FileInputStream() NN_NOEXCEPT override;
    errno_t Init() NN_NOEXCEPT
    {
        constexpr FileInputStreamSettings settings;
        return this->Init(settings);
    }
    errno_t Init(const FileInputStreamSettings& settings) NN_NOEXCEPT;
    errno_t Open(const char* filename) NN_NOEXCEPT;
    errno_t Open(const wchar_t* filename) NN_NOEXCEPT;
    errno_t FdOpen(nlib_fd fd) NN_NOEXCEPT;
    nlib_fd GetFd() const NN_NOEXCEPT
    {
        return m_Fd;
    }

private:
    virtual size_t FillBuffer_(void* p, size_t nbytes) NN_NOEXCEPT override;
    virtual bool Close_() NN_NOEXCEPT override;
    virtual void* GetWorkBuffer_(size_t* nbytes) NN_NOEXCEPT override;

private:
    nlib_fd m_Fd;
    unsigned char* m_Buf;
    size_t m_BufSize;
    bool m_IsInternalBuf;

    FileInputStream(const FileInputStream&) = delete;
    void operator=(const FileInputStream&) = delete;
};

}}} // nn::ngc::detail
