﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace IFFRefGen.Src
{
    // ドキュメントのグローバルクラス
    public static class GDoc
    {
        // 初期化
        public static void Initialize()
        {
            // ドキュメント読み込み
            InitializeElement();
        }

        // 要素ドキュメントの初期化
        private static void InitializeElement()
        {
            foreach (string filePath in Directory.EnumerateFiles(
                GApp.Config.ContentFolder, "*.xml",
                SearchOption.TopDirectoryOnly))
            {
                DocElementFile document = DocElementFile.Read(filePath);
                foreach (DocElement element in document.Elements)
                {
                    element.FilePath = filePath;
                    GDoc.Elements.Add(element.Name, element);

                    if (element.Attributes == null) { continue; }
                    foreach (DocAttribute attribute in element.Attributes)
                    {
                        attribute.FilePath = filePath;
                    }
                }
            }
        }

        // element
        public static readonly Dictionary<string, DocElement> Elements =
            new Dictionary<string, DocElement>();

        #region テスト
        // 要素ドキュメント書き出しテスト
        public static void WriteElementTest(string filePath)
        {
            DocAttribute attribute = new DocAttribute();
            attribute.Name = "Name";
            attribute.Detail = "Detail";
            attribute.Gx = "Gx";
            attribute.DccExport = DocDccExport.Enable;

            DocElement element = new DocElement();
            element.Name = "Name";
            element.Summary = "Summary";
            element.Detail = "Detail";
            element.Attributes = new DocAttribute[2];
            element.Attributes[0] = attribute;
            element.Attributes[1] = attribute;
            element.Content = "Content";

            DocElementFile elementDocument = new DocElementFile();
            elementDocument.Elements = new DocElement[2];
            elementDocument.Elements[0] = element;
            elementDocument.Elements[1] = element;
            DocElementFile.Write(elementDocument, filePath);
        }
        #endregion
    }
}
