﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.IO;

namespace IFFRefGen.Src
{
    // 要素ドキュメント
    public class DocElement
    {
        // 名前
        [XmlAttribute]
        public string Name { get; set; }

        // 概要
        public string Summary { get; set; }

        // 詳細説明
        public string Detail { get; set; }

        // アトリビュート
        [XmlElement("Attribute")]
        public DocAttribute[] Attributes { get; set; }

        // 内容
        public string Content { get; set; }

        // サンプル
        public DocSample Sample { get; set; }

        // DCC 出力無効
        [XmlAttribute()]
        public bool DccExportDisable { get; set; }

        // ファイルパス
        [XmlIgnore]
        public string FilePath { get; set; }

        // ファイル名
        [XmlIgnore]
        public string FileName { get { return Path.GetFileName(this.FilePath); } }

        // 使用フラグ
        [XmlIgnore]
        public bool IsUsed { get; set; }

        // アトリビュートの検索
        public DocAttribute FindAttribute(string attributeName)
        {
            if (this.Attributes == null) { return null; }
            return Array.Find<DocAttribute>(this.Attributes,
                delegate(DocAttribute match) { return (match.Name == attributeName); });
        }
    }

    // サンプルドキュメント
    public class DocSample
    {
        // ファイル名
        [XmlAttribute]
        public string FileName { get; set; }

        // 行数
        [XmlAttribute]
        public int LineNumber { get; set; }
    }

    // 要素ドキュメントファイル
    public class DocElementFile
    {
        [XmlElement("Element")]
        public DocElement[] Elements { get; set; }

        // 読み込み
        public static DocElementFile Read(string filePath)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(DocElementFile));
            DocElementFile elementDocument;
            XmlReaderSettings readerSettings = new XmlReaderSettings();
            readerSettings.CloseInput = true;
            using (XmlReader reader = XmlReader.Create(
                new FileStream(filePath, FileMode.Open), readerSettings))
            {
                elementDocument = (DocElementFile)serializer.Deserialize(reader);
            }
            return elementDocument;
        }

        // 書き出し
        public static void Write(DocElementFile elementDocument, string filePath)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(DocElementFile));
            XmlWriterSettings settings = new XmlWriterSettings();
            settings.Indent = true;
            settings.IndentChars = "\t";
            settings.NewLineOnAttributes = true;
            settings.CloseOutput = true;
            using (XmlWriter writer = XmlWriter.Create(filePath, settings))
            {
                serializer.Serialize(writer, elementDocument);
            }
        }
    }
}
