﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Xml;
using System.IO;

namespace IFFRefGen.Src
{
    // 属性ドキュメント
    public class DocAttribute
    {
        // 名前
        public string Name { get; set; }

        // 詳細説明
        public string Detail { get; set; }

        // 関連 GX 関数
        public string Gx { get; set; }

        // DCCツール出力
        public DocDccExport DccExport { get; set; }

        // ファイルパス
        [XmlIgnore]
        public string FilePath { get; set; }

        // ファイル名
        [XmlIgnore]
        public string FileName { get { return Path.GetFileName(this.FilePath); } }

        // 使用フラグ
        [XmlIgnore]
        public bool IsUsed { get; set; }
    }

    // DCC ツール出力
    public enum DocDccExport
    {
        Default,
        Enable,
        Disable,
        Fixed,
        //Custom, 必要そうであればカスタム表示に対応する
    }

    // 属性ドキュメントファイル
    public class DocAttributeFile
    {
        [XmlElement("Attribute")]
        public DocAttribute[] Attributes { get; set; }

        // 読み込み
        public static DocAttributeFile Read(string filePath)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(DocAttributeFile));
            DocAttributeFile attributeDocument;
            XmlReaderSettings readerSettings = new XmlReaderSettings();
            readerSettings.CloseInput = true;
            using (XmlReader reader = XmlReader.Create(filePath, readerSettings))
            {
                attributeDocument = (DocAttributeFile)serializer.Deserialize(reader);
            }
            return attributeDocument;
        }

        // 書き出し
        public static void Write(DocAttributeFile attributeDocument, string filePath)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(DocAttributeFile));
            XmlWriterSettings settings = new XmlWriterSettings();
            settings.Indent = true;
            settings.IndentChars = "\t";
            settings.NewLineOnAttributes = true;
            settings.CloseOutput = true;
            using (XmlWriter writer = XmlWriter.Create(filePath, settings))
            {
                serializer.Serialize(writer, attributeDocument);
            }
        }
    }
}
