﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using RETVAL = Common.ReturnValue;
using LOG = Common.Logger;

namespace MakeOverloadHd
{
    public class Program
    {
        public static int Main(string[] args)
        {
#if DEBUG
            Console.Write("MakeOverloadHd start\n");
#endif

            // 引数を取得
            if (!CmdlineOption.Parse(args))
            {
                return RETVAL.ErrorCmdlineOptionParse;
            }
            if (CmdlineOption.DoxygenPath == null)
            {
                CmdlineOption.Usage();
                return RETVAL.ErrorSetBasePath;
            }

            try
            {
                // ディレクトリ名の設定
                ParseAndMakeHd2.SetPath(CmdlineOption.DoxygenPath);

                // doxygen XMLファイルからオーバーロードAPIを検索する
                ParseAndMakeHd2.SearchOverloadFunctions();
                // overload.hd および overloadlist.hd を作成する
                ParseAndMakeHd2.MakeHdFiles();
            }
            catch (Exception e)
            {
                Common.UtilException.DumpException(e);
                return RETVAL.ErrorException;
            }

#if DEBUG
            Console.Write("MakeOverloadHd end\n");
#endif
            return RETVAL.ExitSuccess;
        }
    }
}
