﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml;
using System.Diagnostics;
using System.Text.RegularExpressions;

using LOG = Common.Logger;
using FILEIO = Common.FileIOWrapper;

namespace DeleteNaviTab
{
    public class ParseAndWrite
    {
        private const string StartTag = "<div class=\"navtab\">";
        private const string EndTag = "</table>";
        private enum SeachMode
        {
            SEARCH_TABLE,
            SEARCH_OTHER
        }

        /// <summary>
        /// doxygen で SEPARATE_MEMBER_PAGES 有効時に作成されるナビゲーションバーをHTMLファイルから削除します
        /// </summary>
        /// <param name="doxygenpath">ドキュメントパス(%SIGLO_ROOT%\Documents\Outputs\Api 相当)</param>
        public static void DeleteNaviTable(string doxygenpath)
        {
            Common.UtilFs.SetVsHelpBaseDirName(CmdlineOption.InputDirectoryName);
            Common.UtilFs.SetVsHelpDirName(CmdlineOption.OutputDirectoryName);

            // doxygen HTMLファイル存在チェック用ハッシュの初期化
            Common.UtilFs.InitalizeDoxygenHtmlFileNameHash(doxygenpath + Common.UtilFs.GetHtmlDirName());

            string[] filenames = Common.UtilFs.GetDoxygenHtmlFiles();
            foreach (string filename in filenames)
            {
                string filepath = doxygenpath + Common.UtilFs.GetHtmlDirName() + Path.DirectorySeparatorChar + filename;
                string fileData;
                FILEIO.GetData(out fileData, filepath);
                string[] splitStr = { "\n" };
                string[] lines = fileData.Split(splitStr, StringSplitOptions.None);
                if (CheckNabiTable(lines))
                {
                    DeleteNaviTableCore(filepath, lines);
                }
            }
        }

        private static bool CheckNabiTable(string[] lines)
        {
            foreach (string line in lines)
            {
                if (line.Contains(StartTag))
                {
                    return true;
                }
            }
            return false;
        }

        private enum DeleteNavTavMode
        {
            DELETE_OTHER,
            DELETE_DIV,
        }

        // TODO: xmlfilepath ではなく htmlfilepath
        private static void DeleteNaviTableCore(string xmlfilepath, string[] lines)
        {
            //string outputfilepath = xmlfilepath + ".new";

            string writeText = null;
            DeleteNavTavMode mode = DeleteNavTavMode.DELETE_OTHER;

            // MEMO: 書き込むファイルの改行コードはUNIX形式

            foreach (string line in lines)
            {
                switch (mode)
                {
                    case DeleteNavTavMode.DELETE_OTHER:
                        if (line.Contains(StartTag))
                        {
                            mode = DeleteNavTavMode.DELETE_DIV;
                            writeText += line + "\n";
                        }
                        else
                        {
                            writeText += line + "\n";
                        }
                        break;
                    case DeleteNavTavMode.DELETE_DIV:
                        if (line.Contains(EndTag))
                        {
                            mode = DeleteNavTavMode.DELETE_OTHER;
                        }
                        break;
                }
            }

            FILEIO.SetData(ref writeText, xmlfilepath);
        }
    }
}
