﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Text.RegularExpressions;

using LOG = Common.Logger;

namespace Common
{
    public class UtilDoxygen
    {
        private static string[] skipApiName = { "NN_DEFINE", "NN_OS_STATIC_ASSERT_TRIVIAL", "NW_DEPRECATED_FUNCTION", "NW_STATIC_ASSERT", "NW_UT_RUNTIME_TYPEINFO" };
        private static string[] skipWord = { "operator" };

        // doxygen refidのうち最後の"_1aXXXXXXXXXXXX"の部分を削除します
        public static string CutDoxygenId(string refid)
        {
            Regex r = new Regex(@"^(\w+)_([0-9a-zA-Z]+)$");
            Match m = r.Match(refid);

            if (m.Success)
            {
                return m.Groups[1].Value;
            }
            else
            {
                LOG.LogLine(LOG.Level.LOG_ERROR, "CutDoxygenId : refid of member is invalid : {0}", refid);
                return null;
            }
        }

        public static string GetOverloadlistArgument(string line)
        {
            const string CommandName = "@overloadlist";
            Regex r = new Regex(CommandName + @"\s*\{(\w+)\}", RegexOptions.IgnoreCase);
            Match m = r.Match(line);

            if (m.Success)
            {
                // {} の中身を取得しリストに保存
                return m.Groups[1].Value;
            }
            else
            {
                return null;
            }
        }

        public static bool CheckOverloadlistArgument(string line, string paramString)
        {
            if (paramString != null)
            {
                // LOG.Log(LOG.Level.LOG_INFO, "found string = {0}\n", paramString);
                if (paramString.Contains(":"))
                {
                    // @overloadlist の引数がC++スタイルの場合は警告を出力する
                    LOG.Log(LOG.Level.LOG_WARN, "@overloadlist doesn't support delimiter colon ({0})", paramString);
                    return false;
                }
            }
            else
            {
                // {}がない場合はエラー
                LOG.Log(LOG.Level.LOG_WARN, "argument of @overloadlist is NOT FOUND : {0}\n", line);
                return false;
            }
            return true;
        }

        public static bool CheckSkipApi(string functionName)
        {
            if (functionName == null)
            {
                return false;
            }
            foreach (string skipName in skipApiName)
            {
                if (functionName.Contains(skipName))
                {
                    return true;
                }
            }
            foreach (string skipword in skipWord)
            {
                if (functionName.StartsWith(skipword) && (functionName.Equals(skipword) || char.IsLetter(functionName, skipword.Length) == false))
                {
                    return true;
                }
            }
            return false;
        }
    }
}
