﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.DotNetLocalizer
{
    public sealed class LocalizationResourceEnumeratorInvoker : MarshalByRefObject
    {
        public static LocalizationItem[] Invoke(string applicationBase, string privateBinPath, string[] excludes)
        {
            AppDomain newDomain = null;
            try
            {
                newDomain = AppDomainUtility.CreateAppDomain(applicationBase, privateBinPath);
                var guiLocalizerApp = AppDomainUtility.CreateInstance<LocalizationResourceEnumeratorInvoker>(newDomain);

                // ホスティング・クラスのエントリポイントを呼び出す
                var result = guiLocalizerApp.Execute(applicationBase, excludes, privateBinPath);

                return
                    null == result ?
                        null :
                        result;
            }
            finally
            {
                if (null != newDomain)
                {
                    AppDomain.Unload(newDomain);
                }
            }
        }

        private LocalizationItem[] Execute(
            string applicationBase,
            string[] excludes,
            string privateBinPath)
        {
            var asmFiles = AssemblyUtility.GetAsmFiles(applicationBase, excludes, privateBinPath);

            var xmlLocGenerator = new LocalizationResourceEnumerator();
            return xmlLocGenerator.EnumerateLocalizeItems(asmFiles).ToArray();
        }
    }
}
