﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeDictionarySource
{
    internal class MakeDictionaryCppParams
    {
        [CommandLineOption("dummy",
            DefaultValue = false,
            Description = "空の辞書データをもとに .h ファイルと .cpp ファイルを生成します")]
        public bool Dummy { get; set; }
        [CommandLineOption('i',
            IsRequired = false,
            Description = "<パス> を入力の .mo ファイルとして指定します",
            ValueName = "パス")]
        public string InputPath { get; set; }
        [CommandLineOption("output_header",
            IsRequired = false,
            Description = "<パス> を .h ファイルの出力先として指定します",
            ValueName = "パス")]
        public string OutputHeaderPath { get; set; }
        [CommandLineOption("output_cpp",
            IsRequired = false,
            Description = "<パス> を .cpp ファイルの出力先として指定します",
            ValueName = "パス")]
        public string OutputCppPath { get; set; }
        [CommandLineOption("module",
            IsRequired = true,
            Description = "<モジュール> を モジュール名として指定します",
            ValueName = "モジュール")]
        public string ModuleName { get; set; }
        [CommandLineOption("include",
            IsRequired = false,
            Description = "出力する .cpp / .h ファイル内で、<インクルード対象> をインクルードします",
            ValueName = "インクルード対象")]
        public string AdditionalInclude { get; set; }
    }
}
