﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.IO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PushChecker
{
    internal class PushCheckerParams
    {
        [CommandLineOption("git", IsRequired = true, ValueName = "path_to_git", Description = "The path to git.exe")]
        public string GitPath { get; set; }

        [CommandLineValue(0, IsRequired = true, ValueName = "remote", Description = "Name of the destination remote")]
        public string Remote { get; set; }

        [CommandLineValue(1, IsRequired = true, ValueName = "url", Description = "Location of the destination remote")]
        public string Url { get; set; }
    }
}
