﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reflection;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.CompilerServices;
using System.Diagnostics.Contracts;

namespace CommitLogChecker
{
    internal static class Utils
    {
        // JIRA KEY リストを読み込みます。
        internal static List<string> ReadJiraKeyList(string listPath)
        {
            if (string.IsNullOrEmpty(listPath))
            {
                return new List<string>();
            }

            try
            {
                return File.ReadAllLines(listPath)
                    .Select(line => line.Trim())
                    .Where(line => !string.IsNullOrEmpty(line))
                    .Distinct()
                    .ToList();
            }
            catch (Exception)
            {
                Console.Error.WriteLine("ERROR: JIRA KEY リストファイルが不正です。");
                throw;
            }
        }
    }
}
