﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.ToolFoundation.IO;
using System;
using System.Reflection;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace CommitContentChecker
{
    internal class CommitContentCheckerParams
    {
        [CommandLineOption("git", IsRequired = true, ValueName = "path_to_git", Description = "The path to git.exe")]
        public string GitPath { get; set; }

        [CommandLineOption("against_commit", IsRequired = true, ValueName = "against_commit", Description = "The base commit")]
        public string Against { get; set; }

        [CommandLineOption("target_extension_list", IsRequired = false, ValueName = "path_to_target_extension_list", Description = "The path to target extension list file")]
        public string TargetExtensionListFile { get; set; }
    }
}
