<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Starts the network test server on the PC

    .DESCRIPTION
        - Runs the network test server
        
#>

param
(
    [string]
    # SDK root directory
    $sigloRoot =
    ($env:NINTENDO_SDK_ROOT | ? { $_ } | % { $_.Trim() }),

    [string]
    # Host's IP address
    $HostIpAddress =
    ($env:HOSTPRIVATEIPADDR | ? { $_ } | % { $_.Trim() })    
)

# start the DNS server
& Programs\Eris\Outputs\Win32-v140\TargetTools\SettingsManager\Develop\SettingsManager.exe Import "$sigloRoot\Tests\Net\Resources\NetworkSettingsForCI_CustomDns.txt"
& Tests\Outputs\Win32-v140\Tests\KillPids\Develop\KillPids.exe --PidsFile=AllPids.txt --IgnoreFailure=true
Start-Process -FilePath "Externals\Binaries\Python27\python.exe" -ArgumentList "Externals\Binaries\Python27\Scripts\twistd.py -ny Tests\Net\Resources\DNS.py"

# start the Apache server
& Externals\Binaries\Apache24\bin\httpd.exe -f $sigloRoot\Tests\curl\Resources\ApacheSetup\httpd.conf