<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Runs a test game *.nsp on the device

    .DESCRIPTION
        - Runs the *.nsp file on the device
        
#>

param
(
    [string]
    # SDK root directory
    $sigloRoot =
    ($env:NINTENDO_SDK_ROOT | ? { $_ } | % { $_.Trim() }),

    [string]
    # Device's IP address
    $TargetAddress =
    ($env:TARGET_ADDRESS | ? { $_ } | % { $_.Trim() }),

    [string]
    # path to the test game
    #   eg. Tests\Outputs\Porterhouse\porter_house.nsp
    $destinationFileName =
    ($env:DESTINATION_FILE_NAME),

    [int]
    # flag to determine if a user account should be created
    #   eg. 1 for true, 0 for false
    $flagCreateUserAccount =
    ($env:FLAG_CREATE_USER_ACCOUNT),

    [string]
    # full source dir of the autorun file
    #   eg. $sigloRoot\Tests\Outputs\turbos\autorun  or leave empty if no autorun.nut
    $autorunSourceDir =
    ($env:AUTORUN_SOURCE_DIR),
    
    [string]
    # full destination dir to copy the autorun file on the SD card. Copied from path is from $destinationFileName
    #   eg. sd:/GearResource/Debug/Script or leave empty if no autorun.nut
    $autorunDestinationDir =
    ($env:AUTORUN_DESTINATION_DIR)

)

# clear the SD card on the device before running test game to avoid user prompt
& Tools\CommandLineTools\ControlTarget.exe connect
& Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nsp -- sdcard format
& Tools\CommandLineTools\ControlTarget.exe reset --hard --target $TargetAddress
& Tools\CommandLineTools\ControlTarget.exe connect

if ($flagCreateUserAccount -eq 1)
{
    # create a user account to avoid user prompt
    Write-Host "--- creating an user account"
    & Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nsp -- account clear_all
    & Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nsp -- account add
    & Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nsp -- account enable cfg:skip_selection_if_possible
}

if ($autorunSourceDir)
{
    # copy the autorun file on the SD card
    Write-Host "--- Copying all files from $autorunSourceDir to $autorunDestinationDir"
    Start-Process -FilePath "Tools\CommandLineTools\RunOnTarget.exe" -ArgumentList "./Tests/Outputs/NX-NXFP2-a64/Tests/GetSdCardFiles/Develop/GetSdCardFiles.nsp -- --read_dir=$autorunSourceDir --write_dir=$autorunDestinationDir" -Wait
}

# enable logging on the device
Write-Host "Enable logging on the device SD card"
& Tools\CommandLineTools\RunOnTarget.exe ./Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Develop/DevMenuCommandSystem.nsp -- debug enable-sd-card-logging
& Tools\CommandLineTools\ControlTarget.exe reset --hard --target $TargetAddress
& Tools\CommandLineTools\ControlTarget.exe connect

# run *.nsp file on device.  Test game runs forever until it's killed
Write-Host "--- file name:  " $sigloRoot\$destinationFileName
& Tools\CommandLineTools\RunOnTarget.exe $destinationFileName  --no-wait --failure-timeout 120

# make sure the test game has time to completely load
Start-sleep -s 60
