@echo off
:: Copyright (C)2013 Nintendo Co., Ltd.  All rights reserved.
:: 
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.

:: ---------------------------------------------------------------------------
::
:: Setup development environments.
::
:: ---------------------------------------------------------------------------

:: ----------------------------------------------------------------------------
::  Move to the working copy root directory.
:: ----------------------------------------------------------------------------
pushd "%~dp0\..\.."

set NINTENDO_SDK_ROOT=%CD%
set PATH=%CD%\Integrate\CommandLineTools;%CD%\Tools\CommandLineTools;%CD%\Integrate\Scripts;%PATH%

:: ----------------------------------------------------------------------------
::  Setup tool's path.
:: ----------------------------------------------------------------------------
call Integrate\Scripts\Modules\Get-GitPath.bat

set SIGLO_MSYS_PATH=%SIGLO_GIT_PATH%
if exist "%SIGLO_MSYS_PATH%" set PATH=%PATH%;%SIGLO_MSYS_PATH%bin
echo Msys path     : %SIGLO_MSYS_PATH%

:: cygwin
if not defined SIGLO_CYGWIN_PATH (
    FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Cygwin\setup" /v rootdir 2>nul"') DO set "SIGLO_CYGWIN_PATH=%%b\"
)
if not defined SIGLO_CYGWIN_PATH (
    FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Cygwin\setup" /v rootdir 2>nul"') DO set "SIGLO_CYGWIN_PATH=%%b\"
)
echo Cygwin path   : %SIGLO_CYGWIN_PATH%

:: ConEmu x64 (https://code.google.com/p/conemu-maximus5/)
FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\ConEmu" /v InstallDir_x64 2>nul"') DO set "SIGLO_CONEMU_PATH=%%b%ConEmu64.exe"
echo ConEmu path   : %SIGLO_CONEMU_PATH%

:: ----------------------------------------------------------------------------
::  Setup Toolchains.
:: ----------------------------------------------------------------------------
powershell -ExecutionPolicy RemoteSigned Integrate\Scripts\Setup-ToolChain.ps1

:: ----------------------------------------------------------------------------
::  Setup VisualStudio environments.
:: ----------------------------------------------------------------------------
:: Recover VS140COMNTOOLS if it is not defined. (Some tool projects use VS140COMNTOOLS in their build events.)
if not defined VS140COMNTOOLS (
    FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKCU\SOFTWARE\Microsoft\VisualStudio\SxS\VS7" /v 14.0 2>nul"') DO set "VS140COMNTOOLS=%%bCommon7\Tools\"
)
if not defined VS140COMNTOOLS (
    FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKLM\SOFTWARE\Microsoft\VisualStudio\SxS\VS7" /v 14.0 2>nul"') DO set "VS140COMNTOOLS=%%bCommon7\Tools\"
)
if not defined VS140COMNTOOLS (
    FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKCU\SOFTWARE\Wow6432Node\Microsoft\VisualStudio\SxS\VS7" /v 14.0 2>nul"') DO set "VS140COMNTOOLS=%%bCommon7\Tools\"
)
if not defined VS140COMNTOOLS (
    FOR /F "tokens=2*" %%a IN ('cmd /c "REG QUERY "HKLM\SOFTWARE\Wow6432Node\Microsoft\VisualStudio\SxS\VS7" /v 14.0 2>nul"') DO set "VS140COMNTOOLS=%%bCommon7\Tools\"
)

echo VS140COMNTOOLS: %VS140COMNTOOLS%
if not defined VS140COMNTOOLS (
    echo ERROR: VS140COMNTOOLS is not set. Please install VS2015.
)

:: ----------------------------------------------------------------------------
::  Test the current environments.
:: ----------------------------------------------------------------------------
echo Testing the current environments...
call sigloDevEnvTest.cmd 0
if not %ERRORLEVEL% == 0 (
    color 6
    echo ***************************************************************
    echo WARNING: Some errors were detected in the current environments.
    echo ***************************************************************
    timeout 60
    color
)

:: ----------------------------------------------------------------------------
::  Setup development environments.
:: ----------------------------------------------------------------------------
call setupSigloDevEnv.cmd

if not %ERRORLEVEL% == 0 (
    echo ERROR: fail to setup siglo development environment. 1>&2
    goto exit
)

:: ----------------------------------------------------------------------------
::  Start PuTTY authentication agent (if necessary)
:: ----------------------------------------------------------------------------
call Integrate\Repository\Tools\GitExternalRepository\startAgent.cmd

:exit
rem pause
popd
endlocal
