﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Set TeamCityBuildTag

    .DESCRIPTION
        Set TeamCity build tags to TeamCity server.
#>

Param(
  # TeamCity のサーバ URL を指定します。
  [string]
  $Url,

  # 認証情報が書かれた設定ファイルを指定します
  # 以下、設定ファイルのサンプルです
  # <?xml version="1.0"?>
  # <Configuration>
  #   <User>ユーザ名</User>
  #   <Password>パスワード</Password>
  # </Configuration>
  [string]$AuthenticationFile,

  # ログ取得対象のビルド ID を指定します。
  [string]$BuildId,

  # 登録するタグをカンマ区切りで指定します。
  [string]$Tags
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${ScriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\TeamCity"

# 例外ハンドラ
trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if ([string]::IsNullOrEmpty($Url))
{
    throw "Url が指定されていません"
}

if ([string]::IsNullOrEmpty($AuthenticationFile))
{
    throw "AuthenticationFile が指定されていません"
}

if ([string]::IsNullOrEmpty($BuildId))
{
    throw "BuildId が指定されていません"
}

if ([string]::IsNullOrEmpty($Tags))
{
    throw "Tags が指定されていません"
}

$authFile = [xml](Get-Content $AuthenticationFile -ErrorAction Stop)
$userName = $authFile.Configuration.User
$password = $authFile.Configuration.Password
$tagList = $Tags.Split(",")

$response = Set-TeamCityBuildTags -Url $Url -UserName $userName -Password $password -BuildLocator "id:$BuildId" -Tags $tagList

Write-Output "Response: $response"
