﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    Rynda のzipを展開します。また、バージョンのヘッダファイルを作成します。

    .DESCRIPTION
    Rynda のzipを展開します。また、バージョンのヘッダファイルを作成します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param
(
    # Rynda zipファイルのパスを指定します。
    [Parameter(Mandatory=$true)]
    [string] $RyndaPath,

    # Rynda のファイル名を指定します。
    [Parameter(Mandatory=$true)]
    [string] $RyndaFileName,

    # 7-Zip へのパスを指定します。
    [Parameter(Mandatory=$true)]
    [string] $SevenZipPath,

    # Rynda zip の展開先を指定します。
    [Parameter(Mandatory=$true)]
    [string] $OutputRyndaDir,

    # 出力するバージョンファイルのパスを指定します。
    [Parameter(Mandatory=$true)]
    [string] $OutputVersionFile,

    # 静的ライブラリを含めるかどうかを指定します。
    [Parameter()]
    [switch] $IncludeStaticLibrary,

    # 静的ライブラリを指定します。
    [Parameter()]
    [string[]] $StaticLibrary =
        @(
        "nx/armv7l/lib/fixed-x18/",
        "nx/armv7l/lib/kernel/",
        "nx/armv7l/lib/noeh/",
        "nx/armv7l/lib/noeh+noimplicitfloat/",
        "nx/armv7l/lib/noimplicitfloat/",
        "nx/armv7l/lib/pickernel/",
        "nx/armv7l/lib/libc.a",
        "nx/armv7l/lib/libc++.a",
        "nx/armv7l/lib/libc++abi.a",
        "nx/armv7l/lib/libunwind.a",
        "nx/armv7l/lib/libcompiler_rt.a",
        "nx/armv7l/lib/libshim.a",
        "nx/aarch64/lib/fixed-x18/",
        "nx/aarch64/lib/kernel/",
        "nx/aarch64/lib/noeh/",
        "nx/aarch64/lib/noeh+noimplicitfloat/",
        "nx/aarch64/lib/noimplicitfloat/",
        "nx/aarch64/lib/pickernel/",
        "nx/aarch64/lib/libc.a",
        "nx/aarch64/lib/libc++.a",
        "nx/aarch64/lib/libc++abi.a",
        "nx/aarch64/lib/libcompiler_rt.a",
        "nx/aarch64/lib/libshim.a",
        "nx/aarch64/lib/libunwind.a"
        )
)

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

Import-Module $scriptDir/../Modules/Error
Import-Module $scriptDir/../Modules/Path

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$ErrorActionPreference = "Stop"

$ryndaFileName -match '\d+\.\d+\.\d+$' > $nul
$ryndaVersion = $Matches[0]

if (Test-Path $OutputRyndaDir) {
    Remove-Item $OutputRyndaDir -Recurse
}

if ($IncludeStaticLibrary) {
    $libOptPre = 'i'
} else {
    $libOptPre = 'x'
}

$staticLibParam =
    $StaticLibrary |
    ForEach-Object {
        '-{0}!clang*/{1}' -f $libOptPre, $_
    }        

& $SevenZipPath  x "-o$OutputRyndaDir" "$RyndaPath\$ryndaFileName.zip" '-x!clang*\README*.*' @staticLibParam |
Where-Object { $_ -notmatch '^Extracting ' }

if ($LastExitCode) {
    throw "7-Zip failed. - $LastExitCode"
}

Get-Item $OutputRyndaDir\clang* |
ForEach-Object {
    Rename-Item $_.FullName -NewName clang
}
   
# Ryndaのバージョンを設定した version.h を作成
$verHeaderStr =
@'
#define NN_SDK_VERSION_MAJOR          {0}
#define NN_SDK_VERSION_MINOR          {1}
#define NN_SDK_VERSION_MICRO          {2}
#define NN_SDK_VERSION_RELSTEP        0
'@

$ryndaVersion -match '(\d+)\.(\d+)\.(\d+)' > $nul
$verHeaderStr -f $Matches[1..3] | Set-Content $OutputVersionFile -Encoding UTF8
