<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write the Package2 for enabling EDEV log by FRCM
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = 'K3' # K1, K2, K3
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$WritePackage2 = "$scriptDirectoryPath/Write-Package2-Frcm.ps1"
$Package2      = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/Package2Images/Package2ForEdevLog/$BuildType/Package2ForEdevLog.package2.img"

Invoke-Expression "& `"$WritePackage2`" `"$Package2`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType"
