<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Dump boot images by FRCM
#>
[CmdletBinding()]
Param
(
    [string]
    $OutputName = '',

    [string]
    $KeyType = 'K3' # K1, K2, K3
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

$RcmWriter          = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.exe"
$RcmWriterRcm       = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.rcm"
$RcmWriterRcmOld    = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/RcmWriter/RcmWriter.$KeyType.old.rcm"
$RcmWriterXml       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RcmWriter/Dump-BootImages.xml"
$RcmWriterAdditionalOptions = ""

if($KeyType -eq 'M2')
{
    $RcmWriterAdditionalOptions = "--old_rcm `"$RcmWriterRcmOld`""
}

$DefaultName        = Get-Date -Format "yyyy-MMdd-HHmmss"
$OutputDirectoryRoot= "$(Get-NintendoSdkRootPath)/Integrate/Outputs/DumpedBootImages"
if($OutputName -ne "")
{
    $OutputDirectory = "$OutputDirectoryRoot/$OutputName"   
}
else
{
    $OutputDirectory    = "$OutputDirectoryRoot/$DefaultName"
}
$OutputConfig       = "$OutputDirectory/RcmWriterConfig.xml"
$OutputBootConfig   = "$OutputDirectory/BootConfig.img"
$Bct00 = "$OutputDirectory/Bct00-NormalMain.img"
$Bct01 = "$OutputDirectory/Bct01-SafeMain.img"
$Bct02 = "$OutputDirectory/Bct02-NormalBackup.img"
$Bct03 = "$OutputDirectory/Bct03-SafeBackup.img"

$Bl00 = "$OutputDirectory/Bl00-NormalMain.img"
$Bl01 = "$OutputDirectory/Bl01-NormalSub.img"
$Bl02 = "$OutputDirectory/Bl02-SafeMain.img"
$Bl03 = "$OutputDirectory/Bl03-SafeSub.img"

$BlTruncated00 = "$OutputDirectory/BlTruncated00-NormalMain.img"
$BlTruncated01 = "$OutputDirectory/BlTruncated01-NormalSub.img"
$BlTruncated02 = "$OutputDirectory/BlTruncated02-SafeMain.img"
$BlTruncated03 = "$OutputDirectory/BlTruncated03-SafeSub.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Test existing files
Test-EnsureExistPath $RcmWriter
Test-EnsureExistPath $RcmWriterRcm
Test-EnsureExistPath $RcmWriterXml

# 出力ディレクトリの確保
if (!(Test-Path $OutputDirectoryRoot)) {
    mkdir $OutputDirectoryRoot > $null
}

if (!(Test-Path $OutputDirectory)) {
    mkdir $OutputDirectory > $null
}

# Configファイルのコピー
cp $RcmWriterXml $OutputConfig

# Rcm の実行
Invoke-CriticalCommand "& `"$RcmWriter`" --rcm `"$RcmWriterRcm`" --list `"$OutputConfig`" $RcmWriterAdditionalOptions"

# Bct での EKS のゼロ埋め
Write-Zero $Bct00 -Start 1104 -Size 176
Write-Zero $Bct01 -Start 1104 -Size 176
Write-Zero $Bct02 -Start 1104 -Size 176
Write-Zero $Bct03 -Start 1104 -Size 176

# 大きいファイルのカット
# 書き込むイメージよりパーティションのほうが大きい奴が対象となる
New-TruncatedFile -Source $Bl00 -Output $BlTruncated00 -Size 102400
New-TruncatedFile -Source $Bl01 -Output $BlTruncated01 -Size 102400
New-TruncatedFile -Source $Bl02 -Output $BlTruncated02 -Size 102400
New-TruncatedFile -Source $Bl03 -Output $BlTruncated03 -Size 102400

Write-Host "Dumped to $OutputDirectory"
