﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        CMAC 付き初期化イメージ(*.initimgm)を用いて修理用システムを消去します。

    .DESCRIPTION
        CMAC 付き初期化イメージ(*.initimgm)を用いて修理用システムを消去します。
#>

[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $ConfigName = "TestWsIssuerServerConfig",

    [string]
    $FirstInitializeType = "None",

    [string]
    $DevicePath = "",

    [string]
    $DoProcessClean = "true"
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Names
$ImageName                = "ClearSafe"

# File names
$RunSystemInitializerManu = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RunSystemInitializerManu.exe"
$ImagePath                = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/NX-NXFP2-a64/InitialImages/$ImageName/$BuildType/$ImageName.initimgm"
$TemporaryDirectory       = "$(Get-NintendoSdkRootPath)/Integrate/Outputs"
$ConfigPath               = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RequestToWsIssuerConfig/$ConfigName.yaml"

# Test existing files
Test-EnsureExistPath $RunSystemInitializerManu
Test-EnsureExistPath $ImagePath
Test-EnsureExistPath $ConfigPath

$DevicePathOption = ""
if($DevicePath)
{
    $DevicePathOption = "--usb_device_path $DevicePath"
}

if($DoProcessClean -eq "true")
{
    Stop-ProcessesForSystemInitialize
}
else
{
    Write-Host "Skip Process Cleaning."
}

if (!(Test-Path $TemporaryDirectory)) {
    New-Item $TemporaryDirectory -itemType Directory | Out-Null
}

# Initialize
Invoke-Expression "& `"$RunSystemInitializerManu`" $DevicePathOption --verbose --image $ImagePath --initializer 0100000000002103 --tmpdir $TemporaryDirectory --config $ConfigPath --timeout 180 `"--`" --enable-overwriting-production-info --enable-erase-emmc"

