<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create Prod PreFinalize nfa

    .DESCRIPTION
        Create Prod PreFinalize nfa
#>
[CmdletBinding()]
Param
(
    [string]
    $SignedType = 'None',
    
    [string]
    $ConnectionType = 'Manu',

    [string]
    $DeveloperType = 'Repair',
    
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64'
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

$DevArchiveName  = "RecoveryWriter-K5-Manu-Unsigned-Repair"
$DevArchivePath  = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$DevArchiveName/$BuildType/$DevArchiveName.nfa"

$ProdArchiveName  = "${DeveloperType}SSP-$ConnectionType-P2${SignedType}-Prod"
$ProdArchivePath  = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ProdArchiveName/$BuildType/$ProdArchiveName.nfa"

$ChangeFirmwareArchiveKey = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ChangeFirmwareArchiveKey.exe"
$ChangeFirmwareArchiveResult = [System.IO.Path]::GetDirectoryName($ProdArchivePath)
$KeyConfigPath        = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/AuthoringTool/AuthoringTool.repository.keyconfig.xml";

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Write-Output "Exe : $ChangeFirmwareArchiveKey"
Write-Output "In  : $DevArchivePath"
Write-Output "Out : $ProdArchivePath"
Write-Output "Key : $KeyConfigPath"

Test-EnsureExistPath $DevArchivePath
Test-EnsureExistPath $ChangeFirmwareArchiveKey
Test-EnsureExistPath $KeyConfigPath
 
Invoke-Expression "& `"$ChangeFirmwareArchiveKey`" --verbose -i `"$DevArchivePath`" -o `"$ProdArchivePath`" --keyconfig `"$KeyConfigPath`" --result `"$ChangeFirmwareArchiveResult`""