<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Copy Product Images To Appropriate Path

    .DESCRIPTION
        Copy Product Images To Appropriate Path
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',
    
    [string]
    $ConnectionType = 'Manu',
    
    [string]
    $SignedType = 'Signed',
    
    [string]
    $BootType = 'ManuBoot',
    
    [string]
    $StorageSize = '32G',
    
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $PackageZipPath = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../../Modules/Localize"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$SignedFRCPath = "$(Get-NintendoSdkRootPath)/Externals/NxProdBinariesPrivate/Drivers/SignedFRC_for_win10"

Test-EnsureExistPath $SignedFRCPath

if([string]::IsNullOrEmpty($PackageZipPath))
{
    $PackageZipPath = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/Packages/NX/RepairDev/RepairPackageDevWithoutPrivateBinaries.zip"
}

$UnzipDirectory       = "$(Get-NintendoSdkRootPath)/RepairUnzip"
if (Test-Path $UnzipDirectory) {
    Remove-Item $UnzipDirectory -Recurse
}
Expand-Zip $PackageZipPath "$UnzipDirectory"

Copy-Item -Recurse $SignedFRCPath $UnzipDirectory/RepairPackageDevWithoutPrivateBinaries\Tools\Drivers
$OutputZip = Join-Path (Split-Path $PackageZipPath) "RepairPackageDev.zip"
New-Zip -Path $OutputZip  -Input $UnzipDirectory/RepairPackageDevWithoutPrivateBinaries

Remove-Item $UnzipDirectory -Recurse