<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>
[CmdletBinding()]
Param
(
    [string]
    $AddressPattern = '.*',

    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "K5",

    [string]
    $SignedType = 'Signed'
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"

$WriteRecovery      = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Write-RecoverySystem.ps1"
$RecoveryWriterName = "RecoveryWriter-$KeyType-Hb-$SignedType"
$RecoveryWriter     = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/QspiBootImages/$RecoveryWriterName/$BuildType/$RecoveryWriterName.qspi.img"
$InitialImageName   = "NX-$KeyType-Hb-$SignedType-Nand-64G-Shipping"
$InitialImagePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.initimg"
$SystemUpdater =    "$(Get-NintendoSdkRootPath)/Programs/Chris/Outputs/$Platform/TargetTools/SystemUpdaterHostFs/$BuildType/SystemUpdaterHostFs.nsp"
$RunOnTarget        = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RunOnTargetPrivate.exe"
$ControlTarget      = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ControlTarget.exe"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-ParameterIsNotNullOrEmpty -Name "AddressPattern" -Value $AddressPattern

Test-EnsureExistPath $RecoveryWriter
Test-EnsureExistPath $InitialImagePath
Test-EnsureExistPath $SystemUpdater
Test-EnsureExistPath $RunOnTarget

$TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern

Stop-ProcessesForSystemInitialize
Unregister-AllTargets

# Write recovery system.
Invoke-CriticalCommand "& `"$WriteRecovery`" -AddressPattern $AddressPattern -RecoveryWriter $RecoveryWriter"

Invoke-CriticalCommand "& `"$ControlTarget`" connect -t $TargetAddress --reset"
Invoke-CriticalCommand "& `"$ControlTarget`" disconnect -t $TargetAddress"
Invoke-CriticalCommand "& `"$ControlTarget`" connect -t $TargetAddress --reset"

# Write
Invoke-CriticalCommand "& `"$RunOnTarget`" run $TargetOption --reset --wait-after-reset 10 --verbose --monitor-serial --hostbridge $TargetAddress --failure-timeout 600 --pattern-success-exit `"Succeeded initializing the system.`" `"$SystemUpdater`" '--' --enable-overwriting-production-info --input `"$InitialImagePath`""

# Reset
Invoke-CriticalCommand "& `"$ControlTarget`" reset"
