<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize prod mp by system updater.

    .DESCRIPTION
        Initialize prod mp by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $Path
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$AuthoringTool = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/AuthoringTool/AuthoringTool.exe"
$KeyConfig = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/AuthoringTool/AuthoringTool.repository.keyconfig.xml"

Invoke-Expression "& `"$AuthoringTool`" prodencryption --gamecard --auto-boot --keyconfig `"$KeyConfig`" `"$Path`""
