<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create PseudoProdKey Qspi Image

    .DESCRIPTION
        Create PseudoProdKey Qspi Image
#>
[CmdletBinding()]
Param
(
    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Signed',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '32G',

    [string]
    $DeveloperType = 'ManufacturingTest',

    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [switch]
    $Encrypt = $false
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$SystemPartitionName       = "Manufacture1stInitializeSystemPartition";
$SystemPartitionNamePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/SystemPartition/$SystemPartitionName/$BuildType/$SystemPartitionName.prod.fatimg"
$QspiBootArchivePath       = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$SystemPartitionName/$BuildType/$SystemPartitionName.prod.nfa"
$MakeSignedSystemPartition = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeSignedSystemPartition.exe"
$InternalSignKeyFile       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/SignedFatImage/Internal.yaml"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $QspiBootArchivePath
Test-EnsureExistPath $MakeSignedSystemPartition
Test-EnsureExistPath $InternalSignKeyFile

$OutputDirectoryPath = [System.IO.Path]::GetDirectoryName($SystemPartitionNamePath)
if (!(Test-Path $OutputDirectoryPath)) {
    New-Item $OutputDirectoryPath -itemType Directory | Out-Null
}

if($Encrypt)
{
    $EncryptOption = "--encrypt"
}
Invoke-Expression "& `"$MakeSignedSystemPartition`" --size 11 --free-space 2900KiB -i `"$QspiBootArchivePath`" -o `"$SystemPartitionNamePath`" --key `"$InternalSignKeyFile`" $EncryptOption"
