<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Make InitialImage with CMAC.

    .DESCRIPTION
        Make InitialImage with CMAC.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "K3",

    [string]
    $ConnectionType = "Manu",

    [string]
    $BootType = "ManuBoot",

    [string]
    $SignedType = "Signed",

    [string]
    $StorageSize = "32G",

    [string]
    $DeveloperType = "ManufacturingTest",

    [string]
    $CmacKeyName = "TestWsIssuerCmacKey",

    [string]
    $CmacKeyFile = "",

    [string]
    $Suffix = ''
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

if($Suffix.Length -ne 0)
{
    Write-Host "  Suffix:         $Suffix"
}

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$CmacFileTool           = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/CmacFileTool.exe"
$KeyFile                = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/CmacKey/$CmacKeyName.txt"
$InitialImageName       = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$SourceInitialImage     = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName$Suffix.initimg"
$OutputCmacInitialImage = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName$Suffix.initimgm"

if ($CmacKeyFile -ne "") {
    $KeyFile        = $CmacKeyFile
}

Write-Output "Key:"
Write-Output "     $KeyFile"
Write-Output "Input:"
Write-Output "    $SourceInitialImage"
Write-Output "Output:"
Write-Output "    $OutputCmacInitialImage"

Invoke-Expression "& `"$CmacFileTool`" append -i $SourceInitialImage -o $OutputCmacInitialImage --new-key $KeyFile"
