﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        WindowsErrorReporting Module

    .DESCRIPTION
        This file defines functions for WER(Windows Error Reporting) operations
#>


$key = "HKCU:\Software\Microsoft\Windows\Windows Error Reporting"

function Assert-KeyExistence
{
    if (-not (Test-Path $key))
    {
        throw "`"${key}`" not found"
    }
}

<#
    .SYNOPSIS
        Disables Windows Error Reporting
#>
function Disable-WindowsErrorReporting
{
    Assert-KeyExistence

    Set-ItemProperty $key -Name DontShowUI -Type DWord -Value 1
}
Export-ModuleMember -Function Disable-WindowsErrorReporting

<#
    .SYNOPSIS
        Enables Windows Error Reporting
#>
function Enable-WindowsErrorReporting
{
    Assert-KeyExistence

    Set-ItemProperty $key -Name DontShowUI -Type DWord -Value 0
}
Export-ModuleMember -Function Enable-WindowsErrorReporting

<#
    .SYNOPSIS
        Retrieves the Windows Error Reporting status

    .OUTPUTS
        String instance
#>
function Get-WindowsErrorReporting
{
    Assert-KeyExistence

    if ((Get-ItemProperty $key).DontShowUI)
    {
        return "disabled"
    }
    else
    {
        return "enabled"
    }
}
Export-ModuleMember -Function Get-WindowsErrorReporting
