﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        UpdateKernel Module

    .DESCRIPTION
        This file defines functions for kernel update operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Update kernel image on the target
#>
function Update-Kernel
{
    param
    (
        [Parameter(Mandatory=$true)]
        $kernelPlatform,

        [Parameter(Mandatory=$true)]
        $BuildType
    )

    Write-Host "== Update kernel image ==="

    $FlashMinRoot = "D:/Tools/flash-min"
    $mkkernelimgPath = "$FlashMinRoot\bin\mkkernelimg"
    $controlTargetPath = "D:\Tools\ControlTarget\ControlTarget.exe"

    $kernelDir = "$(Get-NintendoSdkRootPath)\Programs/Chris/Outputs/${kernelPlatform}/Kernel/${BuildType}/"

    Start-Process $mkkernelimgPath -ArgumentList "--kernel $kernelDir/CODE_ENTRY --ramdisk $kernelDir/INITIAL_PROCESS -o ./kernel.img" -NoNewWindow -Wait

    Start-Process $controlTargetPath -ArgumentList "force-recovery" -NoNewWindow -Wait

    Start-Sleep 3

    $pythonDir  = "$(Get-NintendoSdkRootPath)\Externals\Binaries\Python27"
    $pythonPath = "${pythonDir}\python.exe"

    $WriteKernelArgument  = "$FlashMinRoot/bin/tegraflash.py "
    $WriteKernelArgument += "--applet $FlashMinRoot/nvtboot_recovery.bin "
    $WriteKernelArgument += "--bct $FlashMinRoot/bct_p2530_e01.cfg "
    $WriteKernelArgument += "--bl $FlashMinRoot/cboot_default.bin "
    $WriteKernelArgument += "--cfg $FlashMinRoot/flash_t210_android_sdmmc_fb.xml "
    $WriteKernelArgument += "--chip 0x21 "
    $WriteKernelArgument += "--dtb $FlashMinRoot/tegra210-jetson-e-p2595-0000-a00-00.dtb "
    $WriteKernelArgument += "--nct $FlashMinRoot/nct.bin "
    $WriteKernelArgument += "--odmdata 0x94000 "
    $WriteKernelArgument += "--cmd `"write LNX kernel.img; reboot`""

    Start-Process $pythonPath -ArgumentList "$WriteKernelArgument" -NoNewWindow -Wait

    Write-Host "Done."
}

Export-ModuleMember -Function Update-Kernel
