﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        TeamCity Job Config Module

    .DESCRIPTION
        This file defines functions for getting TeamCity job configs
#>

$BuildConfigs = @{
	"Cafe::build_default"  = @("CheckPackages\Cafe\Default", "BuildSdk\Cafe\Default", "CheckBundleFiles\Cafe\All");
	"Cafe::build_packages" = @("CreatePackages\Cafe\Public");

	"Generic::build_all"                  = @("BuildSdk\Generic\Gcc", "BuildSdk\Generic\All");
	"Generic::build_default"              = @("CheckPackages\Generic\All", "BuildSdk\Generic\Default", "CheckBundleFiles\Generic\All", "CheckVcproject\Generic\All");
	"Generic::build_packages"             = @("CreatePackages\Generic\Public", "CreatePackages\Generic\OasisCheckKit");
	"Generic::build_samples"              = @("BuildSdk\Generic\Tools", "CreatePackages\Generic\Samples");
	"Generic::test_module"                = @("BuildTests\Generic\Win64");
	"Generic::test_module_VS2013_Win32"   = @("BuildTests\Generic\Win32_VS2013");
	"Generic::test_module_VS2013_Win64"   = @("BuildTests\Generic\Win64_VS2013");
	"Generic::test_module_VS2017_Win32"   = @("BuildTests\Generic\Win32_VS2017");
	"Generic::test_module_VS2017_Win64"   = @("BuildTests\Generic\Win64_VS2017");
	"Generic::test_module_Win32"          = @("BuildTests\Generic\Win32");

    "NX::build_all"                         = @("BuildSdk\NX\All");
	"NX::build_default"                     = @("CheckPackages\NX\All", "BuildSdk\NX\Default", "CheckBundleFiles\NX\All", "CheckVcproject\NX\All");
	"NX::build_documents"                   = @("BuildDocuments\Generic\Default");
	"NX::build_packages"                    = @("CreatePackages\NX\Public");
	"NX::build_packages_MinSdk"             = @("BuildTests\NX\MinSdkCommon");
	"NX::build_packages_systemupdater"      = @("CreatePackages\NX\SystemUpdater");
	"NX::build_packages_target-test"        = @("BuildTests\NX\MinSdkCommon");
	"NX::build_packages_test-binaries-a64"  = @("BuildTests\NX\SmokeTestPackage-a64");
	"NX::build_samples"                     = @("BuildSdk\NX\Tools", "CreatePackages\NX\Samples");
	"NX::build_tests"                       = @("BuildTests\NX\NXFP2-a64");
	"NX::test_module_EDEV-a32"              = @("BuildTests\NX\TargetTestPackage-Edev", "BuildTests\NX\SmokeTest-a32");
	"NX::test_module_EDEV-a64"              = @("BuildTests\NX\TargetTestPackage-Edev", "BuildTests\NX\SmokeTest-a64");
	"NX::test_module_SDEV-a32"              = @("BuildTests\NX\TargetTestPackage", "BuildTests\NX\SmokeTest-a32");
	"NX::test_module_SDEV-a64"              = @("BuildTests\NX\TargetTestPackage", "BuildTests\NX\SmokeTest-a64", "BuildTests\NX\SmokeTestForMinimumBoot-a64");
}


<#
    .SYNOPSIS
        Returns TeamCity build configs

    .OUTPUTS
        Array instance
#>
function Get-BuildConfig
{
    param
    (
        [Parameter(Mandatory=$true)]
        [string]$Spec,

		[Parameter(Mandatory=$true)]
		[string]$JobName
    )

	return $BuildConfigs["${Spec}::${JobName}"]
}
Export-ModuleMember -Function Get-BuildConfig
