﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Target Manager Module

    .DESCRIPTION
        This file defines functions for Target Manager operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Start the Target Manager process
#>
function Start-TargetManager
{
    $TargetManagerPath = "$(Get-NintendoSdkRootPath)\Externals\Oasis\bin\NintendoTargetManager.exe"

    $TargetManagerProcess = Get-Process | where {$_.Name.Equals("NintendoTargetManager")}

    if ($TargetManagerProcess -ne $null)
    {
        throw "Target manager already started."
    }

    $TargetManager = Start-Process $TargetManagerPath -PassThru

    if ($TargetManager -eq $null)
    {
        throw "Could not start Target Manager."
    }

    return $TargetManager
}
Export-ModuleMember -Function Start-TargetManager

<#
    .SYNOPSIS
        Stop the Target Manager process
#>
function Stop-TargetManager
{
    param
    (
        [Parameter(Mandatory=$true)]
        $Process
    )

    Stop-Process $Process.Id
}
Export-ModuleMember -Function Stop-TargetManager

