﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        htcDaemon Module

    .DESCRIPTION
        This file defines functions for HtcDaemon operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Check if HtcDaemonProcess exists
#>
function Get-HtcDaemonState
{
    $daemonProcess = Get-Process | where {$_.Name.Equals("HtcDaemon")}

    return $($null -ne $daemonProcess)
}
Export-ModuleMember -Function Get-HtcDaemonState

<#
    .SYNOPSIS
        Start the HtcDaemon process
#>
function Start-HtcDaemon
{
    param
    (
        [Parameter(Mandatory=$true)]
        $Platform
    )

    $chrisDir  = "$(Get-NintendoSdkRootPath)\Programs\Chris"
    $htcDaemonDir = "${chrisDir}\Outputs\AnyCPU\Tools\HtcDaemon\HtcDaemon\Release"
    $htcDaemonPath = "${htcDaemonDir}\HtcDaemon.exe"

    $daemonProcess = Get-Process | where {$_.Name.Equals("HtcDaemon")}

    if($daemonProcess -ne $null) { throw "HtcDaemon already started." }

    switch ($Platform)
    {
        "jetson-tk2"
        {
            $htcDaemon = Start-Process $htcDaemonPath -PassThru -ArgumentList "--usb"
        }
        default
        {
            $htcDaemon = Start-Process $htcDaemonPath -PassThru
        }
    }

    if($htcDaemon -eq $null) { throw "Could not start HtcDaemon." }

    return $htcDaemon
}
Export-ModuleMember -Function Start-HtcDaemon

<#
    .SYNOPSIS
        Stop the HtcDaemon process
#>
function Stop-HtcDaemon
{
    param
    (
        [Parameter(Mandatory=$true)]
        $Process
    )

    Stop-Process $Process.Id
}
Export-ModuleMember -Function Stop-HtcDaemon
