﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    ローカライズされたファイルで元のファイルを置換します。

    .DESCRIPTION
    ローカライズされたファイルで元のファイルを置換します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # 翻訳用リポジトリのルートを指定します。
    [parameter(Mandatory = $true,
               Position = 0)]
    [string] $TranslationRoot,

    # 言語(日本語は 'ja', 英語は 'en')を指定します。
    [parameter(Mandatory = $true,
               Position = 1)]
    [string] $Lang,

    [parameter()]
    [switch] $NoReplaceLocalizeFile
)

$sigloRoot = (Join-Path $MyInvocation.MyCommand.Path ../../../.. | Resolve-Path).Path

Import-Module $sigloRoot/Integrate/Scripts/Modules/Localize

if (!$NoReplaceLocalizeFile) {
    & $sigloRoot/Integrate/Scripts/Localize/Set-LocalizeFile.ps1 $TranslationRoot $Lang
}

if ($Lang -eq 'en') {
    # 中間ファイルフォーマットHTMLのコピー
    $dstDir = mkdir $sigloRoot/Documents/Outputs -Force
    Copy-Item $TranslationRoot/$Lang/ApiReference/Documents/IntermediateFileFormat $dstDir.FullName `
        -Recurse -Force

    # LocalizationItem.xml(ja/en)のコピー
    & $sigloRoot/Integrate/Scripts/Localize/Copy-DotNetLocalizeFile.ps1 $TranslationRoot

    & $sigloRoot/Integrate/Scripts/Localize/Replace-EnBundleFile.ps1
}
