﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    英語版のバンドル定義ファイルでバンドル定義ファイルを更新します。

    .DESCRIPTION
    英語版のバンドル定義ファイルでバンドル定義ファイルを更新します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # バンドル定義ファイルが置かれているディレクトリを指定します。
    [string]$BundleDir = "Integrate/Packages/BundleDefinitions"
)

$sigloRoot = (Join-Path $MyInvocation.MyCommand.Path ../../../.. | Resolve-Path).Path

Get-ChildItem $sigloRoot/$BundleDir -Include *-en.bundle.yml -Recurse |
ForEach-Object {
    $tgtZarf = $_.FullName -replace '-en(?=\.bundle\.yml$)',''
    if (Test-Path $tgtZarf) {
        Copy-Item $_.FullName $tgtZarf -Force
    }
}
