﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    .NET Framework ツールのローカライズ処理を行う New-DotNetLocalizeFile を呼び出します。

    .DESCRIPTION
    .NET Framework ツールのローカライズ処理を行う New-DotNetLocalizeFile を呼び出します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # 対象のアセンブリがあるディレクトリを指定します。
    [parameter(Mandatory = $true,
               Position = 0)]
    [string] $ApplicationBase,

    # 入力用日本語翻訳項目XMLファイルのパスを指定します。
    [parameter(Mandatory = $true,
               Position = 1)]
    [string] $InputLocalizationItemJa,

    # 入力用英語翻訳項目XMLファイルのパスを指定します。
    [parameter(Mandatory = $true,
               Position = 2)]
    [string] $InputLocalizationItemEn,

    # 出力用日本語翻訳項目XMLファイルのパスを指定します。
    [parameter(Mandatory = $true,
               Position = 3)]
    [string] $OutputLocalizationItemJa,

    # 出力用翻訳マップファイル(xlsx)のパスを指定します。
    [parameter(Mandatory = $true,
               Position = 4)]
    [string] $OutputLocalizationMap,

    # 設定ファイルをのパスを指定します。
    [parameter()]
    [string] $Config,

    # 除外アセンブリパターンを指定します。
    [parameter()]
    [string[]] $Exclude = ('^ToolFoundation$', '^GameToolFoundation$', '^System\.', '^Microsoft\.', '\.XmlSerializers$', '^IronPython', '^IronRuby', '^msvc', '^vccorlib', '^vcomp'),

    [parameter()]
    [string] $ToolConfiguration = "System32"
)

$ErrorActionPreference = "Stop"

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

if ($ToolConfiguration -eq "System32" -and (Test-Path $Env:SystemRoot/Sysnative)) {
    $sysDir = "Sysnative"
} else {
    $sysDir = $ToolConfiguration
}
$powerShellExe = "$Env:SystemRoot/$sysDir/WindowsPowerShell/v1.0/powershell"

$addParam = @()
if ($Config) { $addParam += "-Config", $Config }
if ($Exclude) { $addParam += "-Exclude", ($Exclude -join ",") }

& $powerShellExe -Sta -NoLogo -NonInteractive -NoProfile -ExecutionPolicy ByPass `
    -Command $scriptDir/New-DotNetLocalizeFile `
        -ApplicationBase $ApplicationBase `
        -InputLocalizationItemJa $InputLocalizationItemJa `
        -InputLocalizationItemEn $InputLocalizationItemEn `
        -OutputLocalizationItemJa $OutputLocalizationItemJa `
        -OutputLocalizationMap $OutputLocalizationMap `
        @addParam

if ($LastExitCode -ne 0) {
    throw "New-DotNetLocalizeFile failed. - $LastExitCode"
}
