param(
    [string]$PhidgetsPath="c:\phidgetsCom.exe",
	[string]$Sequence="BbCcAa____", 
	[int]$Tempo=1000, # in milliseconds per beat. Keep in mind that the relays take about half a second to operate.
	[bool]$Repeats=0,
	[int]$Serial=378983
)
<#
    Copyright (C)2016 Nintendo Co., Ltd.  All rights reserved.

    These coded instructions, statements, and computer programs contain
    proprietary information of Nintendo of America Inc. and/or Nintendo
    Company Ltd., and are protected by Federal copyright law.  They may
    not be disclosed to third parties or copied or duplicated in any form,
    in whole or in part, without the prior written consent of Nintendo.
#>

<#
    .SYNOPSIS
        Press physical buttons through phidgetsCom.exe -> phidgets relay board -> ジョイコン(JoyCon)
		
		This script is meant as an automation helper for bluetooth ジョイコン(JoyCon)
		It will 'play' through a sequence of button pushes at a given rate, 
		and will repeat if necessary.　
		All buttons will be 'un-pushed' at the end of the script or in case of any error.
		The reason for this is that electrical cooking is slow, and, in an accident, we might cook for a long time.
		
		Usage examples:
		Push a button and hold it for an hour, then let go.
		Start-PhidgetSequence -PhidgetsPath c:\phidgetsCom.exe  -Sequence Aa  -Tempo 3600000  -Repeats 0
		
		Push and un-push one button twice as often as another.
		Start-PhidgetSequence -PhidgetsPath c:\phidgetsCom.exe  -Sequence ABbaBb

		Arpeggiate all buttons forever.
		Start-PhidgetSequence -PhidgetsPath c:\phidgetsCom.exe  -Sequence ABCD____abcd____
#>


###############################################
# Main script
###############################################

Write-Host "=================================="
Write-Host "Starting $($MyInvocation.MyCommand.Name)..."
Write-Host "=================================="


    # Make sure we have phidgetsCom.exe
    if(!(Test-Path $PhidgetsPath))
    {
        throw "phidgetsCom.exe could not be found at path: ${PhidgetsPath}"
    }
    
    try
    {
		$i=0;
		$length = $Sequence.Length;
		while($i -le $length)
		{
			$c = $Sequence[$i];
			switch ($c)
			{
				{$_ -ceq 'a'} { Write-Host $"Relay$Serial[1   /4] = off";Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=0 -o=off" -Wait -NoNewWindow; break;}
				{$_ -ceq 'A'} { Write-Host $"Relay$Serial[1   /4] = ON"; Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=0 -o=on"  -Wait -NoNewWindow; break;}
				{$_ -ceq 'b'} { Write-Host $"Relay$Serial[ 2  /4] = off";Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=1 -o=off" -Wait -NoNewWindow; break;}
				{$_ -ceq 'B'} { Write-Host $"Relay$Serial[ 2  /4] = ON"; Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=1 -o=on"  -Wait -NoNewWindow; break;}
				{$_ -ceq 'c'} { Write-Host $"Relay$Serial[  3 /4] = off";Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=2 -o=off" -Wait -NoNewWindow; break;}
				{$_ -ceq 'C'} { Write-Host $"Relay$Serial[  3 /4] = ON"; Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=2 -o=on"  -Wait -NoNewWindow; break;}
				{$_ -ceq 'd'} { Write-Host $"Relay$Serial[   4/4] = off";Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=3 -o=off" -Wait -NoNewWindow; break;}
				{$_ -ceq 'D'} { Write-Host $"Relay$Serial[   4/4] = ON"; Start-Process -Filepath $PhidgetsPath -ArgumentList " -s=$Serial -p=3 -o=on"  -Wait -NoNewWindow; break;}
				"_" { Write-Host $"Sleeping for $Tempo ms"; Start-Sleep -Milliseconds $Tempo; break;}
				default { Write-Host $"Sleeping for $Tempo ms"; Start-Sleep -Milliseconds $Tempo; break;}
			} 
			 Start-Sleep -Milliseconds $Tempo;
			
			$i = $i + 1;
			if($Repeats){ if($i -eq $length ){ $i = 0; }}
		}
    }
    finally
    {	
		Write-Host $"Resetting relays to open.";
        # Always leave our phidgets relays in an open state, electrical cooking is slow
        Start-Process -Filepath $PhidgetsPath -ArgumentList "-p=0 -o=off" -NoNewWindow
        Start-Process -Filepath $PhidgetsPath -ArgumentList "-p=1 -o=off" -NoNewWindow
        Start-Process -Filepath $PhidgetsPath -ArgumentList "-p=2 -o=off" -NoNewWindow
        Start-Process -Filepath $PhidgetsPath -ArgumentList "-p=3 -o=off" -NoNewWindow
    }


