﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke Sleep on Target

    .DESCRIPTION
        Run Sleep and Wake.
#>

param
(
    [int]
    $TimeOfFirstPowerButtonPush = 5,

    [int]
    $TimeOfSecondPowerButtonPush = 20,

    [int]
    $TimeOfSleepBeforeTest = 10,

    [int]
    $TimeOfSleepAfterTest = 0,

    [string]
    $TargetInterface = "Ethernet",

    [string]
    $TargetAddress
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\HostBridge"
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if ([string]::IsNullOrEmpty($TargetAddress))
{
    if ("Ethernet" -ceq $TargetInterface)
    {
        throw "TargetAddress not specified"
    }
}

# TORIAEZU :
#  dll が読めないので、暫定対応として、Outputs 以下の ControlTarget を実行
$ControlTarget = Get-NintendoSdkRootPath
$ControlTarget = [IO.Path]::Combine($ControlTarget, "Programs\Chris\Outputs")
$ControlTarget = [IO.Path]::Combine($ControlTarget, "x86")
$ControlTarget = [IO.Path]::Combine($ControlTarget, "Tools\RunnerTools")
$ControlTarget = [IO.Path]::Combine($ControlTarget, "ControlTargetPrivate")
$ControlTarget = [IO.Path]::Combine($ControlTarget, "Release")
$ControlTarget = [IO.Path]::Combine($ControlTarget, "ControlTargetPrivate.exe")

Start-Sleep -Seconds $TimeOfSleepBeforeTest

if( $TargetInterface -eq "Ethernet" ) {
    $command  = ("&", "`"$ControlTarget`"", "press-power-button-for-sc7")
    $command += ("--ip-addr", $TargetAddress)
    $command = $command -join " "
} else {
    # USB 接続の場合は Phidgets を使う
    # power-on-phidgets コマンドで Power ボタンをちょん押しするので、スリープ・ウェイクできる
    $command = ("&", "`"$ControlTarget`"", "power-on-phidgets")
    $command = $command -join " "
}

# スリープに入る
Start-Sleep -Seconds $TimeOfFirstPowerButtonPush
Invoke-Expression $command

if(0 -ne $LastExitCode) { exit $LastExitCode }

# スリープ復帰
Start-Sleep -Seconds $TimeOfSecondPowerButtonPush
Invoke-Expression $command

Start-Sleep -Seconds $TimeOfSleepAfterTest

# Pass exitCode to TestRunner's result
exit $LastExitCode
