﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    変更履歴を作成します。

    .DESCRIPTION
    変更履歴を作成します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>

[CmdletBinding()]
Param(
    # 出力するディレクトリを指定します
    [parameter(Mandatory = $true)]
    [string]$OutputDir,

    # エイリアス情報が書かれている xml ファイル指定します。
    [parameter(Mandatory = $true)]
    [string]$AliasFile,

    # outputChangeLog用のConfigファイルを指定します。
    [parameter(Mandatory = $true)]
    [string]$ChangelogConfig,

    # APIリファレンスへの位置を $OutputDir からの相対で指定します。
    [parameter(Mandatory = $true)]
    [string]$PreApiUrl,

    # 認証ファイルを指定します。
    [parameter(Mandatory = $true)]
    [string]$AuthenticationFile,

    # コンポーネント情報変換ファイルを指定します。
    [parameter(Mandatory = $true)]
    [string]$ComponentRuleFile,

    # 対象プロジェクトを指定します。
    [parameter(Mandatory = $true)]
    [string]$Project,

    # gatherChangeLog用のConfigファイルを指定します。
    [parameter()]
    [string]$GatherConfig,

    # 英語版を作成します。
    [parameter()]
    [switch]$English,

    # 公開ドキュメントへの位置を $OutputDir/ReleaseNotes からの相対で指定します。
    [parameter()]
    [string]$PreDocUrl = "../../Pages/",

    # 調査する JIRA 課題の最大数を指定します。
    # 省略時(あるいは0を指定時) はすべてを取得します。
    [parameter()]
    [int]$MaxArticle = 3000
)

$ErrorActionPreference = "Stop"

$sigloRoot = Join-Path $MyInvocation.MyCommand.Path ../../.. | Convert-Path

# スクリプトが次の場所で動作することを期待しているため移動する。
Push-Location $sigloRoot/Integrate/Sources/Tools/ReleaseNoteTools

$addParam = @()
if ($English) {
    $addParam += "-English"
}

# Gather logs from JIRA
if ($GatherConfig -and $AuthenticationFile) {
    powershell.exe -NoLogo -NonInteractive -NoProfile -ExecutionPolicy ByPass `
        -File ./gatherChangeLog.ps1 `
        -AuthenticationFile $AuthenticationFile `
        -AliasFile $AliasFile `
        -ComponentRuleFile $ComponentRuleFile `
        -Project $Project `
        -ConfigFile $GatherConfig `
        -CheckHtml `
        -MaxArticle $MaxArticle

    if ($LastExitCode) {
        throw "gatherChangeLog.ps1 failed. - $LastExitCode"
    }
}

# Output ChangeLog
powershell.exe -NoLogo -NonInteractive -NoProfile -ExecutionPolicy ByPass `
    -File ./outputChangeLog.ps1 `
    -AuthenticationFile $AuthenticationFile `
    -OutputDir $OutputDir `
    -AliasFile $AliasFile `
    -ConfigFile $ChangelogConfig `
    -PreApiUrl $PreApiUrl `
    -PreDocUrl $PreDocUrl `
    $addParam

if ($LastExitCode) {
    throw "outputChangeLog.ps1 failed. - $LastExitCode"
}

# Scan SpanLink
powershell.exe -NoLogo -NonInteractive -NoProfile -ExecutionPolicy ByPass `
    -File ./scanSpanLink.ps1 `
    -AuthenticationFile $AuthenticationFile `
    -OutputDir $OutputDir `
    -ConfigFile $ChangelogConfig `
    -Overwrite `
    $addParam

if ($LastExitCode) {
    throw "scanSpanLink.ps1 failed. - $LastExitCode"
}

Pop-Location

# Copy Html template
mkdir $OutputDir/template/css -Force > $null
Copy-Item $sigloRoot/Integrate/Sources/Tools/ReleaseNoteTools/html/Resources/template/css/releasenote.css $OutputDir/template/css
