﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Write-Host "Runtime directory: $([System.Runtime.InteropServices.RuntimeEnvironment]::GetRuntimeDirectory()))"
Write-Host

Set-Alias ngen (Join-Path ([System.Runtime.InteropServices.RuntimeEnvironment]::GetRuntimeDirectory()) ngen.exe)

[AppDomain]::CurrentDomain.GetAssemblies() | ? { $_.location } | sort {Split-path $_.location -leaf} | %{
    $Name = (Split-Path $_.location -leaf)
    if ([System.Runtime.InteropServices.RuntimeEnvironment]::FromGlobalAccessCache($_))
    {
        Write-Host                         "skip       : $Name"
    }else
    {
        Write-Host -ForegroundColor Yellow "generating : $Name"
        ngen $_.location | %{"`t$_"}
    }
}
