﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke CI Build

    .DESCRIPTION
        Execute nact with the settings same as specified TeamCity job.
#>
param
(
	[string]
	$Spec,

	[string]
	$JobName
)
$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\TeamCityJobConfig"

if ($Spec -eq "")
{
    throw "Spec name is required"
}

if ($JobName -eq "")
{
    throw "JobName is required"
}

[System.Array]$buildConfigs = Get-BuildConfig $Spec $JobName

if ( $buildConfigs -eq $null -or $buildConfigs.Length -eq 0 )
{
    throw "No job settings are found: spec = $Spec, job name = $JobName"
}

Write-Host "Start ${Spec}::Public::${JobName}"
$buildConfigs | %{
	$path = "$(Get-NintendoSdkIntegrateRootPath)/Resources/Scripts/Configs/Invoke-Nact/${_}.yml"
    if (-not (Test-Path $path))
    {
        Write-Host "Skip : ${path}"
        return
    }
    Write-Host "Load : ${_}"
    & "$(Get-NintendoSdkIntegrateRootPath)/Scripts/Invoke-Script.ps1" Invoke-Nact $_ -LocalExecutionMode
    if($LastExitCode -ne 0) { break; }
}

exit $LastExitCode
