﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS

    .DESCRIPTION

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>

[CmdletBinding()]
Param(
    # APIリファレンスのディレクトリを指定します
    [parameter()]
    [string]$ApiDir,

    # TagInfo.xml を指定します (複数指定あり。配列)
    [parameter()]
    [string]$TagInfoXml,

    # FairlyLinguistTemplate ファイル名を指定します。
    [parameter()]
    [string]$FairlyLinguistTemplate,

    # Tocの選択を行うスクリプトを指定します。
    [parameter()]
    [string]$TocSelector,

    # エクスポートするConfluenceのスペースキーを指定します。
    [parameter()]
    [string]$ConfluenceSpaceKey = "SIGLODOC,SIGLODOCEN",

    # Confluence の出力フォルダ名を指定します。
    [parameter()]
    [string]$ConfluenceOutputName = "Package",

    # 言語を指定します。ja or en
    [parameter()]
    [string]$Lang = "ja",

    [parameter()]
    [string]$FilterLabelName,

    [parameter()]
    [string]$DoxyTag,

    [parameter()]
    [string]$ExternalDocDir,

    [parameter()]
    [switch]$ConfluenceTranslated
)

$ErrorActionPreference = "Stop"

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

Import-Module $scriptDir/Modules/Error
Import-Module $scriptDir/Modules/Path

$sigloRoot = (Resolve-Path $scriptDir/../..).Path

$documentsRoot = Get-NintendoSdkDocumentsRootPath
$documentsOutputs = Join-Path $documentsRoot Outputs
$documentsIntermediates = Join-Path $documentsRoot Intermediates

$confluenceSpaceKeyAry = $ConfluenceSpaceKey -split ','

# $ApiDir が相対パスのときに絶対パスにする(絶対パスのときは変化なし)。
[string]$apiFullPath = $null
if ($ApiDir) {
    $apiFullPath = [IO.Path]::GetFullPath([IO.Path]::Combine($documentsOutputs, $ApiDir)).TrimEnd(@("\"))
}
# $TagInfoXml はそのまま渡す(絶対パスにするのはスクリプト側で行う)
if ( $TagInfoXml -eq $null )
{
    $TagInfoXml = ""
}

# 展開先のパス
[string[]] $unzipDirectoryPath =
    $confluenceSpaceKeyAry | ForEach-Object { Join-Path $documentsIntermediates Confluence/$_ }

& $sigloRoot/Integrate/Scripts/Build-PublicDocuments.ps1 `
    -ProjectFilePath $documentsRoot/Resources/FairlyWrites/$FairlyLinguistTemplate.template `
    -SourceDirectoryPath ($unzipDirectoryPath  -join ',') `
    -ApiPath $apiFullPath `
    -TagInfoXml $TagInfoXml `
    -ConfluenceOutputName $ConfluenceOutputName `
    -DoxyTag $DoxyTag `
    -ConfluenceTranslated:$ConfluenceTranslated `
    -Lang $Lang

Get-ChildItem $documentsIntermediates/FairlyLinguist/Outputs/$ConfluenceOutputName -Filter 'PageLists.csv' -Recurse |
ForEach-Object {
    & $sigloRoot/Integrate/Scripts/Select-FairlyLinguistError.ps1 `
        ($_.DirectoryName + '/ConvertLog_*.log') `
        $_.FullName
}

# ラベル名でフィルタ（指定したラベルとその子孫ページを除く、すべてのページを削除）
# 最初に指定されたスペースのみ対応しています。
if ($FilterLabelName) {
    & $scriptDir/Remove-FilteredPageFiles.ps1 `
        -XmlPath ($unzipDirectoryPath[0] + "/entities.xml") `
        -FilterLabelName $FilterLabelName `
        -TargetRoot $documentsOutputs/$ConfluenceOutputName
    if ($LastExitCode) {
        throw "Remove-FilteredPageFiles.ps1 failed. - $LastExitCode"
    }
}

# tocData.js 内の目次の項目の選択。
if ($TocSelector) {
    & $scriptDir/$TocSelector $documentsOutputs/$ConfluenceOutputName
}

if ($ExternalDocDir) {
    $ExternalDocDir -split ',' |
    ForEach-Object {
        $extDir = Get-Item $_
        $dstParentDir = mkdir $documentsOutputs/$ConfluenceOutputName/contents -Force
        $dstDir = Join-Path $dstParentDir.FullName $extDir.Name

        # $dstDir があったら削除しておきます。
        if (Test-Path $dstDir) {
            Remove-Item $dstDir -Recurse -Force
        }

        Copy-Item $extDir.FullName $dstParentDir -Recurse -Force
    }
}

# log出力用の作成
mkdir $documentsOutputs/$ConfluenceOutputName/logs -Force > $null

# Create search index
# 標準エラーに出力される内容をリダイレクトしたいけど、
# 普通にコマンド呼び出しで "2>" でリダイレクトさせようとすると、PowerShell のエラー情報が混じり、
# かつ $ErrorActionPreference の影響を受けてしまうので、Start-Process を使うようにします。
$ps = Start-Process `
    -FilePath (Get-CreateSearchDataPath) `
    -ArgumentList ('-console', '-docpath', "$documentsOutputs/$ConfluenceOutputName/contents", '-apipath', $apiFullPath) `
    -RedirectStandardError $documentsOutputs/$ConfluenceOutputName/logs/CreateSearchData.log `
    -NoNewWindow -PassThru -Wait
if ($ps.ExitCode) {
    throw ("CreateSearchData failed. - {0}" -f $ps.ExitCode)
}
