﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Get Performance Logs
#>

param
(
    # TeamCity のログファイルが置かれたディレクトリを指定します。
    [string]
    $LogDirectory
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${ScriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\TeamCity"
Import-Module "${ScriptDirectoryPath}\Modules\Path"

# 例外ハンドラ
trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if ([string]::IsNullOrEmpty($LogDirectory))
{
    throw "LogDirectory が指定されていません"
}

############################################################################
#
# ディレクトリパス
#
############################################################################

# NintendoSdk ディレクトリ
$NintendoSdk = NintendoSdkRootPath

# Documents ディレクトリ
$DocumentsRoot = NintendoSdkDocumentsRootPath

# Documents\Performance ディレクトリ
$PerformanceDocumentsRoot = "${DocumentsRoot}\Performance"

# MakeDataDocuments ツールルート
$MakeDataDocumentsRoot = "${NintendoSdk}\Programs\Chris\Outputs\AnyCPU\Tools\DataDocumentTools"


############################################################################
#
# ツールパス
#
############################################################################

# NactBuildLogParser.exe
$NactBuildLogParserTool = "${MakeDataDocumentsRoot}\NactBuildLogParser\Release\NactBuildLogParser.exe"

# TeamCityLogParser.exe
$TeamCityLogParserTool = "${MakeDataDocumentsRoot}\TeamCityLogParser\Release\TeamCityLogParser.exe"


############################################################################
#
# 1. ログを Documents/Performance/Sources/BuildTime 以下に取得します。
#
############################################################################

$logDirectoryOutput = "${PerformanceDocumentsRoot}\Sources\BuildTime"

if( Test-Path "${logDirectoryOutput}" ){
    rm "${logDirectoryOutput}" -Recurse -ErrorAction "Stop"
}

cp "${LogDirectory}" -Recurse "${logDirectoryOutput}" -ErrorAction "Stop"


############################################################################
#
# 2. ログをパースします。
#
############################################################################

cd "${logDirectoryOutput}"

$LogFiles = Get-ChildItem . | Where-Object { $_.name -like "*.log" }

foreach( $file in ${LogFiles} ){
    # data.json の生成
    Invoke-Expression "& `"${NactBuildLogParserTool}`" ${file}"
    if ( $LastExitCode -ne 0 ) { exit $LastExitCode }

    # meta.json の生成
    Invoke-Expression "& `"${TeamCityLogParserTool}`" ${file}"
    if ( $LastExitCode -ne 0 ) { exit $LastExitCode }
}
