<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Sleep and wake

    .DESCRIPTION
        Sleeps and wakes the EDEV.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\..\Modules\Path"

while (1)
{
    Write-Output "Sleeping..."
    & "$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\ControlTargetPrivate.exe" power-on-phidgets
    Start-Sleep -s 5
    Write-Output "Waking..."
    & "$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\ControlTargetPrivate.exe" power-on-phidgets
    Start-Sleep -s ${env:BGPROCESS_DELAY}
}
