﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

param
(
)

$scriptPath = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
$locateVsixInstallerPath = Join-Path $scriptDirectoryPath "LocateVSIXInstaller.exe"

# VSIXInstaller のパスを取得
$vsixInstallerPath = & $locateVsixInstallerPath
if ($LastExitCode -ne 0)
{
    Write-Host "Visual Studio cannot be found. Skipping uninstallation of NintendoSdkVsExtension."
    exit 0
}

# VSIXInstaller を実行
$argumentList = ("/u:NintendoSdkVsExtension.Nintendo.07f3506c-f4a5-4c70-8a81-93e25dcbc050", "/quiet")

Write-Host "`"$vsixInstallerPath`" $argumentList"
$p = Start-Process -Wait -PassThru -FilePath $vsixInstallerPath -ArgumentList $argumentList

switch ($p.ExitCode)
{
    # Successful
    0
    {
        Write-Host "Successfully uninstalled NintendoSdkVsExtension."
        exit 0
    }
    # NotInstalledException
    # NoApplicableSKUsException
    1002 {} # falls-through
    2003
    {
        Write-Host "NintendoSdkVsExtension is not installed."
        exit 0
    }
    # BlockingProcessesException
    2004
    {
        Write-Host "Failed to uninstall NintendoSdkVsExtension: There is a running instance of Visual Studio or another VSIX installation."
        exit $p.ExitCode
    }
    default 
    {
        Write-Host " Error $($p.ExitCode) returned from the following command:"
        Write-Host "    `"$vsixInstallerPath`" $argumentList"
        exit $p.ExitCode
    }
}
