﻿// 文字コード:UTF-8
/// @file
#pragma once

// プライベート
//@{
#define LIB_UNIQUE_VARIABLE_NAME_CAT_I(S0, S1) S0##S1
// 一見意味が無さそうに見えるが、これを経由しないと期待動作しない、理由は理解できていない
#define LIB_UNIQUE_VARIABLE_NAME_CAT(S0, S1) LIB_UNIQUE_VARIABLE_NAME_CAT_I(S0, S1)
//@}

/// 一意な変数名に置き換わる
#define LIB_UNIQUE_VARIABLE_NAME LIB_UNIQUE_VARIABLE_NAME_CAT(variable, __LINE__)
/// 指定の型で、一意な変数名を宣言する
/// ・「LIB_UNIQUE_VARIABLE_NAME」の場合、このファイルのインクルードを忘れた際に期待しない状態で動作する問題があるので、
///    それを回避する目的で追加した
#define LIB_UNIQUE_VARIABLE_NAME_DECLARE_VARIABLE(X) X LIB_UNIQUE_VARIABLE_NAME_CAT(variable, __LINE__)

// EOF
