﻿// 文字コード:UTF-8
/// @file
#pragma once

LIB_FORWARD_DECLARE_2(lib, class U16String);

#define LIB_U16CSTRING_ARRAY_LITERAL_AND_COUNT(...) (const char16_t*[]){__VA_ARGS__}, (sizeof((const char16_t*[]){__VA_ARGS__}) / sizeof(char16_t*))

//------------------------------------------------------------------------------
namespace lib {

/// C方式の文字列を扱うクラス
class U16CString
{
public:
    static const char16_t EMPTY[];
    static int32_t GetLength(const char16_t* aStr);
#if COMPILER_IS_CLANG // @memo VC環境ではchar16_tはtypedef unsigned shortと定義されているため　多重定義になってしまうのでClang限定としています。
    static int32_t GetLength(const uint16_t* aStr) { return GetLength(reinterpret_cast<const char16_t*>(aStr)); }
#endif
    static void Catenate(char16_t* aStr, const char16_t* aAdditionalStr);
    /**
     * @brief コピー先に必ず終端を付加する文字コピー
     * @param dstNum dst の文字数(=バイト数/sizeof(char16_t))
     * @return 全部コピーできたら true 。打ち切りが発生したら false 。
     * @attention 文字をコピーしきれないときは文字が欠落する
     */
    static void Copy(char16_t* aDst, const char16_t* aSrc, uint32_t aCap);
    /**
     * @brief コピー先に必ず終端を付加する文字コピー
     * @param aDstNum aDst の文字数(=バイト数/sizeof(char16_t))
     * @return 全部コピーできたら true 。打ち切りが発生したら false 。
     * @attention 文字をコピーしきれないときは文字が欠落する
     */
    static bool CopyAsPossible(char16_t* aDst, const char16_t* aSrc, uint32_t aCap);

    static void Format(char16_t* aStr, int aCap, const char16_t* aFmt, ...);
    static void FormatV(char16_t* aStr, int aCap, const char16_t* aFmt, ::std::va_list aVaList);
    static void FormatAsPossible(char16_t* aStr, int aCap, const char16_t* aFmt, ...);
    static void FormatVAsPossible(char16_t* aStr, int aCap, const char16_t* aFmt, ::std::va_list aVaList);
};
} // namespace
// EOF
